package inc.monsters.mias.data.facade;

import inc.monsters.mias.data.Employee;

import java.util.List;
import java.util.logging.Logger;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * Session Bean implementation class EmployeeService
 */
public class EmployeeServiceBean implements EmployeeService {
	private static final Logger log = Logger.getLogger("inc.monsters.mias");
	
	@PersistenceContext
	private EntityManager em;

    /**
     * Default constructor. 
     */
    public EmployeeServiceBean() {
    }
    
    @SuppressWarnings("unchecked")
	@Override
    public List<Employee> getEmployees() {
    	Query q = em.createNamedQuery("Employee.all");
    	return q.getResultList();
    }

	@Override
	public void updateEmployee(Employee emp) {
		log.fine("Merging employee with ID " + emp.getId() + "...");
		if(null == em.find(Employee.class, emp.getId())) {
			throw new IllegalArgumentException("Unknown employee id: " + emp.getId());
		}
		
  		em.merge(emp);
	}

	@Override
	public Employee getEmployeeById(int id) {
    	return em.find(Employee.class, id);
	}
}
